/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.thermal_and_space.datagen;

import cofh.thermal.core.ThermalCore;
import earth.terrarium.adastra.common.registry.ModBlocks;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import mrthomas20121.thermal_and_space.api.AstraStone;
import mrthomas20121.thermal_and_space.api.ThermalOre;
import mrthomas20121.thermal_and_space.init.SpaceBlocks;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;

public class SpaceFeatures {

    public static class Placed {
        public static final ResourceKey<PlacedFeature> SPACE_APATITE = Placed.createKey("space_apatite");
        public static final ResourceKey<PlacedFeature> SPACE_CINNABAR = Placed.createKey("space_cinnabar");
        public static final ResourceKey<PlacedFeature> SPACE_NITER = Placed.createKey("space_niter");
        public static final ResourceKey<PlacedFeature> SPACE_SULFUR = Placed.createKey("space_sulfur");
        public static final ResourceKey<PlacedFeature> SPACE_TIN = Placed.createKey("space_tin");
        public static final ResourceKey<PlacedFeature> SPACE_LEAD = Placed.createKey("space_lead");
        public static final ResourceKey<PlacedFeature> SPACE_SILVER = Placed.createKey("space_silver");
        public static final ResourceKey<PlacedFeature> SPACE_NICKEL = Placed.createKey("space_nickel");
        public static final ResourceKey<PlacedFeature> SPACE_OIL_SAND = Placed.createKey("space_oil_sand");

        private static ResourceKey<PlacedFeature> createKey(String name) {
            return ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)new ResourceLocation("thermal_and_space", name));
        }

        public static void bootstrap(BootstapContext<PlacedFeature> context) {
            HolderGetter configuredFeatures = context.m_255420_(Registries.f_256911_);
            context.m_255272_(SPACE_APATITE, (Object)Placed.placedOreTriangle(configuredFeatures, Configured.SPACE_APATITE, "space_apatite", -16, 120, 9));
            context.m_255272_(SPACE_CINNABAR, (Object)Placed.placedOreTriangle(configuredFeatures, Configured.SPACE_CINNABAR, "space_cinnabar", -16, 90, 6));
            context.m_255272_(SPACE_NITER, (Object)Placed.placedOreTriangle(configuredFeatures, Configured.SPACE_NITER, "space_niter", -16, 90, 7));
            context.m_255272_(SPACE_SULFUR, (Object)Placed.placedOreTriangle(configuredFeatures, Configured.SPACE_SULFUR, "space_sulfur", -16, 120, 10));
            context.m_255272_(SPACE_TIN, (Object)Placed.placedOreUniform(configuredFeatures, Configured.SPACE_TIN, "space_tin", -20, 120, 10));
            context.m_255272_(SPACE_LEAD, (Object)Placed.placedOreUniform(configuredFeatures, Configured.SPACE_LEAD, "space_lead", -20, 80, 9));
            context.m_255272_(SPACE_SILVER, (Object)Placed.placedOreUniform(configuredFeatures, Configured.SPACE_SILVER, "space_silver", -60, 100, 8));
            context.m_255272_(SPACE_NICKEL, (Object)Placed.placedOreUniform(configuredFeatures, Configured.SPACE_NICKEL, "space_nickel", -40, 120, 8));
            context.m_255272_(SPACE_OIL_SAND, (Object)Placed.placedOreUniform(configuredFeatures, Configured.SPACE_OIL_SAND, "space_oil_sand", 40, 120, 12));
        }

        private static PlacedFeature registerPlacedFeature(HolderGetter<ConfiguredFeature<?, ?>> getter, ResourceKey<ConfiguredFeature<?, ?>> feature, PlacementModifier ... modifiers) {
            return new PlacedFeature((Holder)getter.m_255043_(feature), List.of(modifiers));
        }

        private static PlacedFeature placedOreTriangle(HolderGetter<ConfiguredFeature<?, ?>> getter, ResourceKey<ConfiguredFeature<?, ?>> ore, String name, int minY, int maxY, int count) {
            return Placed.registerPlacedFeature(getter, ore, new PlacementModifier[]{CountPlacement.m_191628_((int)count), InSquarePlacement.m_191715_(), HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)minY), (VerticalAnchor)VerticalAnchor.m_158922_((int)maxY)), BiomeFilter.m_191561_()});
        }

        private static PlacedFeature placedOreUniform(HolderGetter<ConfiguredFeature<?, ?>> getter, ResourceKey<ConfiguredFeature<?, ?>> ore, String name, int minY, int maxY, int count) {
            return Placed.registerPlacedFeature(getter, ore, new PlacementModifier[]{CountPlacement.m_191628_((int)count), InSquarePlacement.m_191715_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)minY), (VerticalAnchor)VerticalAnchor.m_158922_((int)maxY)), BiomeFilter.m_191561_()});
        }
    }

    public static class Configured {
        public static final ResourceKey<ConfiguredFeature<?, ?>> SPACE_APATITE = Configured.createKey("space_apatite");
        public static final ResourceKey<ConfiguredFeature<?, ?>> SPACE_CINNABAR = Configured.createKey("space_cinnabar");
        public static final ResourceKey<ConfiguredFeature<?, ?>> SPACE_NITER = Configured.createKey("space_niter");
        public static final ResourceKey<ConfiguredFeature<?, ?>> SPACE_SULFUR = Configured.createKey("space_sulfur");
        public static final ResourceKey<ConfiguredFeature<?, ?>> SPACE_TIN = Configured.createKey("space_tin");
        public static final ResourceKey<ConfiguredFeature<?, ?>> SPACE_LEAD = Configured.createKey("space_lead");
        public static final ResourceKey<ConfiguredFeature<?, ?>> SPACE_SILVER = Configured.createKey("space_silver");
        public static final ResourceKey<ConfiguredFeature<?, ?>> SPACE_NICKEL = Configured.createKey("space_nickel");
        public static final ResourceKey<ConfiguredFeature<?, ?>> SPACE_OIL_SAND = Configured.createKey("space_oil_sand");
        private static TagMatchTest deepslateMatch = new TagMatchTest(BlockTags.f_144267_);

        private static ResourceKey<ConfiguredFeature<?, ?>> createKey(String name) {
            return ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)new ResourceLocation("thermal_and_space", name));
        }

        public static void bootstrap(BootstapContext<ConfiguredFeature<?, ?>> context) {
            FeatureUtils.m_254977_(context, SPACE_APATITE, (Feature)Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(Configured.getOreReplacements(ThermalOre.APATITE), 9));
            FeatureUtils.m_254977_(context, SPACE_CINNABAR, (Feature)Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(Configured.getOreReplacements(ThermalOre.CINNABAR), 5));
            FeatureUtils.m_254977_(context, SPACE_NITER, (Feature)Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(Configured.getOreReplacements(ThermalOre.NITER), 7));
            FeatureUtils.m_254977_(context, SPACE_SULFUR, (Feature)Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(Configured.getOreReplacements(ThermalOre.SULFUR), 10));
            FeatureUtils.m_254977_(context, SPACE_TIN, (Feature)Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(Configured.getOreReplacements(ThermalOre.TIN), 10));
            FeatureUtils.m_254977_(context, SPACE_LEAD, (Feature)Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(Configured.getOreReplacements(ThermalOre.LEAD), 8));
            FeatureUtils.m_254977_(context, SPACE_SILVER, (Feature)Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(Configured.getOreReplacements(ThermalOre.SILVER), 8));
            FeatureUtils.m_254977_(context, SPACE_NICKEL, (Feature)Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(Configured.getOreReplacements(ThermalOre.NICKEL), 8));
            FeatureUtils.m_254977_(context, SPACE_OIL_SAND, (Feature)Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(List.of(OreConfiguration.m_161021_((RuleTest)new BlockMatchTest((Block)ModBlocks.MOON_SAND.get()), (BlockState)((FallingBlock)SpaceBlocks.SAND_ORES.get((Object)AstraStone.MOON).get()).m_49966_()), OreConfiguration.m_161021_((RuleTest)new BlockMatchTest((Block)ModBlocks.MARS_SAND.get()), (BlockState)((FallingBlock)SpaceBlocks.SAND_ORES.get((Object)AstraStone.MARS).get()).m_49966_()), OreConfiguration.m_161021_((RuleTest)new BlockMatchTest((Block)ModBlocks.VENUS_SAND.get()), (BlockState)((FallingBlock)SpaceBlocks.SAND_ORES.get((Object)AstraStone.VENUS).get()).m_49966_())), 20));
        }

        private static List<OreConfiguration.TargetBlockState> getOreReplacements(ThermalOre ore) {
            ArrayList<OreConfiguration.TargetBlockState> oreReplacements = new ArrayList<OreConfiguration.TargetBlockState>();
            for (AstraStone stone : ore.getStones()) {
                SpaceBlocks.ORES.get((Object)stone).get((Object)ore).ifPresent(oreBlock -> oreReplacements.add(OreConfiguration.m_161021_((RuleTest)stone.getTag(), (BlockState)oreBlock.m_49966_())));
            }
            oreReplacements.add(OreConfiguration.m_161021_((RuleTest)deepslateMatch, (BlockState)((Block)ThermalCore.BLOCKS.get("deepslate_" + ore.name().toLowerCase(Locale.ROOT) + "_ore")).m_49966_()));
            return oreReplacements;
        }
    }
}

